<?php
session_start();
require_once 'vendor/autoload.php';
require_once 'helpers/token.inc.php';
require_once 'database.php';
?>
<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Export CSV</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
</head>

<?php
include_once 'export.php';
?>

<body class="d-flex justify-content-center align-items-center vh-100 bg-light">
    <div class="card p-4 shadow-lg" style="width: 700px;">
        <h2 class="text-center mb-4">Export données devis</h2>
        <?php $token = isset($_GET['t']) ? $_GET['t'] : ''; ?>
        <?php if (validateToken($token)): ?>
            <form action="index.php" method="GET">
                <input type="hidden" id="all" name="all" value="<?= isset($_GET['all']) ? $_GET['all'] : '' ?>">
                <input type="hidden" id="id_etab_user" name="id_etab_user" value="<?= isset($_GET['id_etab_user']) ? $_GET['id_etab_user'] : '' ?>">
                <input type="hidden" id="t" name="t" value="<?= isset($_GET['t']) ? $_GET['t'] : '' ?>">
                <div class="d-flex justify-content-between mb-3">
                    <div class="me-2">
                        <label for="start_date" class="form-label">Date Début</label>
                        <input type="date" id="start_date" name="start_date" class="form-control" value="<?= isset($_GET['start_date']) ? $_GET['start_date'] : '' ?>">
                    </div>
                    <div class="me-2">
                        <label for="end_date" class="form-label">Date Fin</label>
                        <input type="date" id="end_date" name="end_date" class="form-control" value="<?= isset($_GET['end_date']) ? $_GET['end_date'] : ''; ?>">
                    </div>
                    <div class="me-2">
                        <label for="min_marge" class="form-label">Marge Min</label>
                        <input type="number" id="min_marge" name="min_marge" min="-999" max="999" class="form-control" value="<?= isset($_GET['min_marge']) ? $_GET['min_marge'] : ''; ?>">
                    </div>
                    <div class="me-2">
                        <label for="max_marge" class="form-label">Marge Max</label>
                        <input type="number" id="max_marge" name="max_marge" min="-999" max="999" class="form-control" value="<?= isset($_GET['max_marge']) ? $_GET['max_marge'] : ''; ?>">
                    </div>
                    <div>
                        <label for="years" class="form-label">Année</label>
                        <select id="years" name="years" class="form-select">
                            <option value="">Tout</option>
                            <?php for ($i = 0; $i < 3; $i++): ?>
                                <option value="<?= date('Y') - $i; ?>" <?= isset($_GET['end_date']) && ($_GET['years'] == date('Y') - $i) ? 'selected' : ''; ?>><?= date('Y') - $i; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
                <div class="d-flex justify-content-between">
                    <button type="submit" name="export" value="etablissement" class="btn btn-danger flex-grow-1 me-2">Export Établissement</button>
                    <button type="submit" name="export" value="departement" class="btn btn-warning flex-grow-1 me-2">Export Département</button>
                    <button type="submit" name="export" value="charge_affaire" class="btn btn-success flex-grow-1">Export Charge d’Affaire</button>
                </div>
                <div class="mt-3">
                    <?php
                    $message =  '';
                    if (isset($_SESSION['return'])) {
                        $return = $_SESSION['return'];
                        switch ($return) {
                            case 1:
                                $message = "<div class='alert alert-success alert-dismissible fade show' role='alert'>
                                        <strong><i class='bi bi-check-circle'></i></strong> {$_SESSION['return_message']}.
                                        <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                                    </div>";
                                $downloadFile = $_SESSION['file'];
                                break;
                            case 2:
                                $message = "<div class='alert alert-warning alert-dismissible fade show' role='alert'>
                                        <strong><i class='bi bi-exclamation-circle'></i></strong> {$_SESSION['return_message']}
                                        <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                                    </div>";
                                break;
                            case 3:
                                $message = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>
                                        <strong><i class='bi bi-x-circle'></i></strong> {$_SESSION['return_message']}
                                        <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                                    </div>";
                                break;
                            default:
                                $message = '';
                                break;
                        }
                    }
                    ?>
                    <?= $message ?? '' ?>

                </div>
                <!-- Force download -->
                <?php if (!empty($downloadFile)): ?>
                    <meta http-equiv="refresh" content="0;url=download.php?file=<?= urlencode($_SESSION['file']) ?>">
                    <!-- <script>
                        window.open('download.php', '_blank');
                    </script> -->
                <?php endif; ?>
            </form>
        <?php else: ?>
            <div class='alert alert-danger alert-dismissible fade show' role='alert'>
                <strong><i class='bi bi-x-circle'></i></strong> Token Non Valide.
                <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
            </div>
        <?php endif; ?>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
</body>

</html>
<?php
unset($_SESSION['return']);
unset($_SESSION['return_message']);
?>