<?php
session_start();

// Check if a file is set
if (!isset($_SESSION['file']) || !file_exists($_SESSION['file'])) {
    header('Location: index_old.php');
    exit;
}

$file = $_SESSION['file'];
$filename = $_SESSION['filename'];

// Serve the file as a download
header('Content-Description: File Transfer');
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($file));

readfile($file);

// Clean up
unlink($file);
unset($_SESSION['file']);
unset($_SESSION['filename']);
unset($_SESSION['return']);

exit;
?>
